<?php
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin'){
    header("Location: login.php"); exit;
}
include "config/db.php";
$msg = "";

if($_SERVER['REQUEST_METHOD']=="POST"){
    $title = trim($_POST['title']);
    $content = trim($_POST['content']);
    $course = $_POST['course'];
    $stmt = $pdo->prepare("INSERT INTO lessons (admin_id,title,content,course) VALUES (?,?,?,?)");
    if($stmt->execute([$_SESSION['user_id'],$title,$content,$course])){
        $msg = "Lesson added successfully!";
    }else{
        $msg = "Failed to add lesson.";
    }
}

include "inc/header.php";
?>

<h2 class="section-title">Add Lesson</h2>
<?php if($msg) echo "<div class='alert'>$msg</div>"; ?>
<form method="POST" class="card fade-in" style="max-width:600px;margin:auto;">
  <label>Lesson Title</label>
  <input type="text" name="title" required>
  <label>Content</label>
  <textarea name="content" rows="6" required></textarea>
  <label>Course</label>
  <select name="course" required>
    <option>Web Design Basics with HTML & CSS</option>
    <option>Web Development with PHP & MySQL</option>
    <option>Python Basics</option>
    <option>Android App Development</option>
  </select>
  <button type="submit" class="btn">Add Lesson</button>
</form>

<?php include "inc/footer.php"; ?>
