<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION["user_id"]) || $_SESSION["role"]!=="student") {
    header("Location: login.php"); exit;
}

$user_id = $_SESSION["user_id"];
$fullname = $_SESSION["fullname"];
$course = $_SESSION["course"];
$profile_picture = $_SESSION["profile_picture"];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Student Dashboard - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:1000px;margin:50px auto;padding:0 20px;}
.card{background:white;padding:20px;border-radius:12px;box-shadow:0 0 12px rgba(0,0,0,0.1);margin-bottom:20px;transition:0.3s;}
.card:hover{box-shadow:0 0 20px rgba(0,0,0,0.2);}
.profile-img{width:80px;height:80px;border-radius:50%;object-fit:cover;}
button{background:#003366;color:white;padding:10px;border:none;border-radius:8px;cursor:pointer;}
button:hover{background:#ff6600;}
</style>
</head>
<body>
<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="dashboard.php">Dashboard</a>
<a href="lessons.php">Lessons</a>
<a href="profile.php">Profile</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Welcome, <?= htmlspecialchars($fullname) ?>!</h2>

<div class="card">
<h3>Your Profile</h3>
<img src="<?= $profile_picture ?>" class="profile-img" alt="Profile">
<p><strong>Course:</strong> <?= htmlspecialchars($course) ?></p>
<a href="profile.php"><button>Edit Profile</button></a>
</div>

<div class="card">
<h3>Available Lessons</h3>
<a href="lessons.php"><button>View Lessons & Submit Assignments</button></a>
</div>

</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
