<?php
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin'){
    header("Location: login.php"); exit;
}
include "config/db.php";

$lesson_id = intval($_GET['lesson_id']);
$msg = "";

// Fetch lesson to verify ownership
$stmt = $pdo->prepare("SELECT * FROM lessons WHERE id=? AND admin_id=?");
$stmt->execute([$lesson_id,$_SESSION['user_id']]);
$lesson = $stmt->fetch();
if(!$lesson){ die("Lesson not found or you do not own it."); }

if($_SERVER['REQUEST_METHOD']=="POST"){
    $question = trim($_POST['question']);
    $a = trim($_POST['option_a']);
    $b = trim($_POST['option_b']);
    $c = trim($_POST['option_c']);
    $d = trim($_POST['option_d']);
    $correct = $_POST['correct_option'];
    $marks = intval($_POST['marks']);

    $stmt2 = $pdo->prepare("INSERT INTO questions (lesson_id,question,option_a,option_b,option_c,option_d,correct_option,marks)
        VALUES(?,?,?,?,?,?,?,?)");
    if($stmt2->execute([$lesson_id,$question,$a,$b,$c,$d,$correct,$marks])){
        $msg = "Question added!";
    }else{
        $msg = "Failed to add question.";
    }
}

include "inc/header.php";
?>
<h2 class="section-title">Add Questions to "<?php echo $lesson['title']; ?>"</h2>
<?php if($msg) echo "<div class='alert'>$msg</div>"; ?>
<form method="POST" class="card fade-in" style="max-width:600px;margin:auto;">
  <label>Question</label>
  <textarea name="question" required></textarea>
  <label>Option A</label><input type="text" name="option_a" required>
  <label>Option B</label><input type="text" name="option_b" required>
  <label>Option C</label><input type="text" name="option_c" required>
  <label>Option D</label><input type="text" name="option_d" required>
  <label>Correct Option</label>
  <select name="correct_option" required>
    <option value="A">A</option>
    <option value="B">B</option>
    <option value="C">C</option>
    <option value="D">D</option>
  </select>
  <label>Marks</label>
  <input type="number" name="marks" value="1" required>
  <button type="submit" class="btn">Add Question</button>
</form>
<?php include "inc/footer.php"; ?>
