<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'student'){
    header("Location: login.php");
    exit;
}

$student_id = $_SESSION['user_id'];
$course = $_SESSION['course'];
$msg = "";

// Handle sending a message
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['message'])){
    $message_text = trim($_POST['message']);
    if($message_text){
        $receiver_role = "admin";
        $stmt = $conn->prepare("INSERT INTO messages(sender_id, receiver_role, course, message_text, sent_at) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param("isss", $student_id, $receiver_role, $course, $message_text);
        if($stmt->execute()){
            $msg = "✅ Message sent!";
        } else {
            $msg = "❌ Error: ".$conn->error;
        }
    }
}

// Fetch messages for this student and course
$stmt = $conn->prepare("SELECT m.*, u.fullname AS sender_name 
                        FROM messages m 
                        LEFT JOIN users u ON u.id = m.sender_id
                        WHERE m.course=? ORDER BY m.sent_at DESC");
$stmt->bind_param("s", $course);
$stmt->execute();
$messages = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Messages - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:800px;margin:50px auto;padding:0 20px;}
.card{background:white;padding:15px;border-radius:12px;box-shadow:0 0 12px rgba(0,0,0,0.1);margin-bottom:15px;animation:fadeIn 0.5s ease-in;}
input,textarea,button{width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
.edit-btn{background:#ff6600;color:white;padding:5px 10px;border:none;border-radius:5px;cursor:pointer;margin-top:5px;}
.edit-btn:hover{background:#003366;}
</style>
</head>
<body>

<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="dashboard.php">Dashboard</a>
<a href="lessons.php">Lessons</a>
<a href="profile.php">Profile</a>
<a href="student_messages.php">Messages</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Messages with Admin</h2>

<?php if($msg): ?>
<div class="<?= strpos($msg,'❌')!==false?'error':'success' ?>">
<?= htmlspecialchars($msg) ?>
</div>
<?php endif; ?>

<form method="POST">
    <textarea name="message" placeholder="Type your message..." required></textarea>
    <button type="submit">Send Message</button>
</form>

<h3>Conversation</h3>
<?php if($messages->num_rows > 0): ?>
    <?php while($m = $messages->fetch_assoc()): ?>
        <div class="card">
            <p><strong><?= htmlspecialchars($m['sender_name'] ?: 'Admin') ?>:</strong></p>
            <p><?= nl2br(htmlspecialchars($m['message_text'])) ?></p>
            <small><?= $m['sent_at'] ?></small>
            <?php if($m['sender_id'] == $student_id): ?>
                <br>
                <a href="edit_student_message.php?id=<?= $m['id'] ?>" class="edit-btn">Edit</a>
            <?php endif; ?>
        </div>
    <?php endwhile; ?>
<?php else: ?>
    <p>No messages yet.</p>
<?php endif; ?>

</div>
<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
