<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION["user_id"]) || $_SESSION["role"]!=="admin"){
    header("Location: login.php"); 
    exit;
}

$msg = "";

// Fetch all submitted assignments for admin's course
$course = $_SESSION["course"];
$stmt = $conn->prepare("
    SELECT a.id, a.student_id, a.lesson_id, a.file_path, a.submitted_at, a.grade, a.feedback, u.fullname AS student_name, l.title AS lesson_title
    FROM assignments a
    JOIN users u ON a.student_id = u.id
    JOIN lessons l ON a.lesson_id = l.id
    WHERE a.course = ?
    ORDER BY a.submitted_at DESC
");
$stmt->bind_param("s", $course);
$stmt->execute();
$assignments = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>View & Mark Assignments - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:900px;margin:50px auto;padding:0 20px;}
.card{background:white;padding:20px;border-radius:12px;box-shadow:0 0 12px rgba(0,0,0,0.1);margin-bottom:20px;animation:fadeIn 0.5s ease-in;}
input,textarea,button{width:100%;margin:5px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
textarea{height:100px;resize:none;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
@keyframes fadeIn{from{opacity:0;transform:translateY(20px);}to{opacity:1;transform:translateY(0);}}
</style>
</head>
<body>

<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="admin_dashboard.php">Dashboard</a>
<a href="post_lesson.php">Post Lesson</a>
<a href="view_submissions.php">View Assignments</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>View & Mark Assignments for <?= htmlspecialchars($course) ?></h2>

<?php if($assignments->num_rows > 0): ?>
    <?php while($a = $assignments->fetch_assoc()): ?>
        <div class="card">
            <p><strong>Student:</strong> <?= htmlspecialchars($a['student_name']) ?></p>
            <p><strong>Lesson:</strong> <?= htmlspecialchars($a['lesson_title']) ?></p>
            <p><strong>Submitted at:</strong> <?= $a['submitted_at'] ?></p>
            <p><a href="<?= htmlspecialchars($a['file_path']) ?>" target="_blank">Download Assignment</a></p>

            <!-- Grade & Feedback Form -->
            <form method="POST" action="grade_assignment.php">
                <input type="hidden" name="assignment_id" value="<?= $a['id'] ?>">
                <label>Grade:</label>
                <input type="text" name="grade" value="<?= htmlspecialchars($a['grade'] ?? '') ?>">
                <label>Feedback:</label>
                <textarea name="feedback"><?= htmlspecialchars($a['feedback'] ?? '') ?></textarea>
                <button type="submit">Save</button>
            </form>
        </div>
    <?php endwhile; ?>
<?php else: ?>
    <p>No assignments submitted yet.</p>
<?php endif; ?>

</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>

</body>
</html>
