<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION["user_id"]) || $_SESSION["role"]!=="admin"){
    header("Location: login.php"); exit;
}

$fullname = $_SESSION["fullname"];
$admin_course = $_SESSION["course"];

// Fetch all students for this admin's course
$stmt = $conn->prepare("SELECT * FROM users WHERE role='student' AND course=?");
$stmt->bind_param("s",$admin_course);
$stmt->execute();
$students = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:1000px;margin:50px auto;padding:0 20px;}
.card{background:white;padding:20px;border-radius:12px;box-shadow:0 0 12px rgba(0,0,0,0.1);margin-bottom:20px;transition:0.3s;}
.card:hover{box-shadow:0 0 20px rgba(0,0,0,0.2);}
button{background:#003366;color:white;padding:10px;border:none;border-radius:8px;cursor:pointer;}
button:hover{background:#ff6600;}
</style>
</head>
<body>
<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="admin_dashboard.php">Dashboard</a>
<a href="post_lesson.php">Post Lesson</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Welcome, <?= htmlspecialchars($fullname) ?>!</h2>

<div class="card">
<h3>Registered Students for <?= htmlspecialchars($admin_course) ?></h3>
<?php if($students->num_rows>0): ?>
<table border="1" cellpadding="10" cellspacing="0" style="width:100%;border-collapse:collapse;">
<tr><th>Full Name</th><th>Email</th><th>Phone</th><th>Age</th></tr>
<?php while($s = $students->fetch_assoc()): ?>
<tr>
<td><?= htmlspecialchars($s['fullname']) ?></td>
<td><?= htmlspecialchars($s['email']) ?></td>
<td><?= htmlspecialchars($s['phone']) ?></td>
<td><?= htmlspecialchars($s['age']) ?></td>
</tr>
<?php endwhile; ?>
</table>
<?php else: ?>
<p>No students registered yet.</p>
<?php endif; ?>
</div>

<div class="card">
<h3>Admin Actions</h3>
<a href="post_lesson.php"><button>Post New Lesson</button></a>
<a href="view_submissions.php"><button>View & Mark Assignments</button></a>
</div>

</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
