<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin'){
    header("Location: login.php");
    exit;
}

$admin_id = $_SESSION['user_id'];
$msg = "";

// Handle reply
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['message_text'], $_POST['student_id'])){
    $student_id = intval($_POST['student_id']);
    $text = trim($_POST['message_text']);
    if($text){
        $receiver_role = 'student';
        $course = $_POST['course'];
        $stmt = $conn->prepare("INSERT INTO messages(sender_id, receiver_role, course, message_text, sent_at) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param("isss", $admin_id, $receiver_role, $course, $text);
        if($stmt->execute()){
            $msg = "✅ Reply sent!";
        } else {
            $msg = "❌ Error: ".$conn->error;
        }
    }
}

// Fetch all student messages
$students = $conn->query("SELECT DISTINCT u.id, u.fullname, u.course FROM users u WHERE u.role='student'");

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Messages - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:800px;margin:50px auto;padding:0 20px;}
.card{background:white;padding:15px;border-radius:12px;box-shadow:0 0 12px rgba(0,0,0,0.1);margin-bottom:15px;}
textarea,button{width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
</style>
</head>
<body>
<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="dashboard.php">Dashboard</a>
<a href="admin_messages.php">Messages</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Student Messages</h2>
<?php if($msg): ?>
<div class="<?= strpos($msg,'❌')!==false?'error':'success' ?>">
<?= htmlspecialchars($msg) ?>
</div>
<?php endif; ?>

<?php while($student = $students->fetch_assoc()): ?>
<div class="card">
<h4><?= htmlspecialchars($student['fullname']) ?> (<?= htmlspecialchars($student['course']) ?>)</h4>
<form method="POST">
<textarea name="message_text" placeholder="Reply to <?= htmlspecialchars($student['fullname']) ?>" required></textarea>
<input type="hidden" name="student_id" value="<?= $student['id'] ?>">
<input type="hidden" name="course" value="<?= htmlspecialchars($student['course']) ?>">
<button type="submit">Send Reply</button>
</form>
</div>
<?php endwhile; ?>

</div>
<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
