<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION["user_id"]) || $_SESSION["role"] !== "admin"){
    header("Location: login.php");
    exit;
}

$msg = "";
$admin_id = $_SESSION["user_id"];
$course = $_SESSION["course"];

if($_SERVER["REQUEST_METHOD"] === "POST"){
    $title = trim($_POST['title']);
    $youtube_link = trim($_POST['youtube_link']);
    $description = trim($_POST['description']);

    $assignment_path = null;

    // Handle optional assignment upload
    if(isset($_FILES['assignment_file']) && $_FILES['assignment_file']['error'] === UPLOAD_ERR_OK){
        $upload_dir = __DIR__ . "/assignments/";
        if(!is_dir($upload_dir)) mkdir($upload_dir, 0755, true);

        $file_tmp = $_FILES['assignment_file']['tmp_name'];
        $file_name = uniqid("assignment_")."_".basename($_FILES['assignment_file']['name']);
        $assignment_path = "assignments/".$file_name;
        move_uploaded_file($file_tmp, $upload_dir.$file_name);
    }

    // Insert lesson
    $stmt = $conn->prepare("INSERT INTO lessons(title, youtube_link, content, course, admin_id, created_at) VALUES(?,?,?,?,?,NOW())");
    $stmt->bind_param("sssis", $title, $youtube_link, $description, $course, $admin_id);
    if($stmt->execute()){
        $lesson_id = $stmt->insert_id;

        // Insert assignment if uploaded
        if($assignment_path){
            $stmt2 = $conn->prepare("INSERT INTO assignments(student_id, lesson_id, course, file_path, submitted_at) VALUES(0, ?, ?, ?, NOW())");
            $stmt2->bind_param("iss", $lesson_id, $course, $assignment_path);
            $stmt2->execute();
        }

        $msg = "✅ Lesson posted successfully!";
    } else {
        $msg = "❌ Database error: ".$conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Post Lesson - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:700px;margin:50px auto;padding:0 20px;}
input,textarea,button{width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
textarea{height:150px;resize:none;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
</style>
</head>
<body>

<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="admin_dashboard.php">Dashboard</a>
<a href="admin_post_lesson.php">Post Lesson</a>
<a href="view_submissions.php">View Assignments</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Post New Lesson</h2>

<?php if($msg): ?>
<div class="<?= strpos($msg,'❌')!==false ? 'error' : 'success' ?>">
<?= htmlspecialchars($msg) ?>
</div>
<?php endif; ?>

<form method="POST" enctype="multipart/form-data">
<label>Lesson Title</label>
<input type="text" name="title" required>

<label>YouTube Link</label>
<input type="url" name="youtube_link" placeholder="https://www.youtube.com/..." required>

<label>Description</label>
<textarea name="description" required></textarea>

<label>Assignment (Optional)</label>
<input type="file" name="assignment_file" accept=".pdf,.doc,.docx,.zip">

<button type="submit">Post Lesson</button>
</form>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>

</body>
</html>
