<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'student'){
    header("Location: login.php");
    exit;
}

$student_id = $_SESSION['user_id'];
$msg = "";

if(empty($_GET['id'])){
    die("❌ Message ID missing.");
}

$message_id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT * FROM messages WHERE id=? AND sender_id=?");
$stmt->bind_param("ii", $message_id, $student_id);
$stmt->execute();
$result = $stmt->get_result();
$message = $result->fetch_assoc();

if(!$message){
    die("❌ Message not found or you do not have permission to edit it.");
}

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['message_text'])){
    $updated_text = trim($_POST['message_text']);
    if($updated_text){
        $stmt = $conn->prepare("UPDATE messages SET message_text=?, sent_at=NOW() WHERE id=? AND sender_id=?");
        $stmt->bind_param("sii", $updated_text, $message_id, $student_id);
        if($stmt->execute()){
            $msg = "✅ Message updated successfully!";
            $message['message_text'] = $updated_text;
        } else {
            $msg = "❌ Error updating message: " . $conn->error;
        }
    } else {
        $msg = "⚠️ Message cannot be empty.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Message - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:700px;margin:50px auto;padding:0 20px;}
textarea,button{width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
</style>
</head>
<body>
<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="dashboard.php">Dashboard</a>
<a href="student_messages.php">Messages</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Edit Your Message</h2>
<?php if($msg): ?>
<div class="<?= strpos($msg,'❌')!==false || strpos($msg,'⚠️')!==false ? 'error':'success' ?>">
<?= htmlspecialchars($msg) ?>
</div>
<?php endif; ?>

<form method="POST">
    <textarea name="message_text" required><?= htmlspecialchars($message['message_text']) ?></textarea>
    <button type="submit">Update Message</button>
</form>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
