<?php
session_start();
include __DIR__ . "/db.php";

$msg = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST["email"]);
    $password = trim($_POST["password"]);

    $stmt = $conn->prepare("SELECT * FROM users WHERE email=?");
    $stmt->bind_param("s",$email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        if (password_verify($password,$user["password"])) {
            $_SESSION["user_id"] = $user["id"];
            $_SESSION["fullname"] = $user["fullname"];
            $_SESSION["role"] = $user["role"];
            $_SESSION["course"] = $user["course"];
            $_SESSION["profile_picture"] = $user["profile_picture"];
            if ($user["role"] === "admin") {
                header("Location: admin_dashboard.php"); exit;
            } else {
                header("Location: dashboard.php"); exit;
            }
        } else { $msg="❌ Invalid password"; }
    } else { $msg="⚠️ No account found with that email"; }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.form-container{max-width:450px;margin:70px auto;background:white;padding:40px;border-radius:15px;box-shadow:0 0 15px rgba(0,0,0,0.1);}
input,button{width:100%;margin:10px 0;padding:12px;border-radius:8px;border:1px solid #ccc;}
button{background:#003366;color:white;border:none;cursor:pointer;transition:0.3s;}
button:hover{background:#ff6600;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
</style>
</head>
<body>
<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="index.php">Home</a>
<a href="register.php">Register</a>
<a href="login.php">Login</a>
<a href="about.php">About Us</a>
<a href="services.php">Services</a>
<a href="contact.php">Contact</a>
</div>
</div>

<div class="form-container">
<h2 style="color:#003366;text-align:center;">Login to Your Account</h2>
<?php if($msg): ?><div class="error"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="POST">
<label>Email</label><input type="email" name="email" required>
<label>Password</label><input type="password" name="password" required>
<button type="submit">Login</button>
</form>
<p style="text-align:center;margin-top:15px;">Don't have an account? <a href="register.php" style="color:#ff6600;">Register here</a></p>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:60px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
