<?php
session_start();
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

include "config/db.php";
$msg = "";

// Handle sending a new message
if($_SERVER['REQUEST_METHOD']=="POST" && isset($_POST['to_user'])){
    $to_user = intval($_POST['to_user']);
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);

    $stmt = $pdo->prepare("INSERT INTO messages (from_user, to_user, subject, message) VALUES (?,?,?,?)");
    if($stmt->execute([$_SESSION['user_id'], $to_user, $subject, $message])){
        $msg = "Message sent successfully!";
    } else {
        $msg = "Failed to send message.";
    }
}

// Fetch inbox messages (messages sent to the logged-in user)
$stmt = $pdo->prepare("
    SELECT m.*, u.fullname AS from_name 
    FROM messages m 
    JOIN users u ON u.id = m.from_user 
    WHERE m.to_user = ? 
    ORDER BY m.created_at DESC
");
$stmt->execute([$_SESSION['user_id']]);
$messages = $stmt->fetchAll();

// Fetch all admins (for students to send messages to lecturers)
$lecturers_stmt = $pdo->prepare("SELECT * FROM users WHERE role='admin'");
$lecturers_stmt->execute();
$lecturers = $lecturers_stmt->fetchAll();

include "inc/header.php";
?>

<h2 class="section-title">Messages</h2>

<?php if($msg) echo "<div class='alert'>$msg</div>"; ?>

<!-- Send Message Form -->
<form method="POST" class="card fade-in" style="max-width:600px;margin:auto;">
  <label>Send To</label>
  <select name="to_user" required>
    <?php foreach($lecturers as $l): ?>
      <option value="<?php echo $l['id']; ?>"><?php echo htmlspecialchars($l['fullname']); ?> (<?php echo htmlspecialchars($l['course']); ?>)</option>
    <?php endforeach; ?>
  </select>

  <label>Subject</label>
  <input type="text" name="subject" required>

  <label>Message</label>
  <textarea name="message" rows="4" required></textarea>

  <button type="submit" class="btn">Send Message</button>
</form>

<!-- Inbox Messages -->
<h3 class="section-title">Inbox</h3>

<?php if(count($messages) > 0): ?>
    <?php foreach($messages as $m): ?>
      <div class="card fade-in">
        <p><strong>From:</strong> <?php echo htmlspecialchars($m['from_name']); ?> | 
           <strong>Subject:</strong> <?php echo htmlspecialchars($m['subject']); ?> | 
           <small><?php echo $m['created_at']; ?></small>
        </p>
        <p><?php echo nl2br(htmlspecialchars($m['message'])); ?></p>
        <?php if(!empty($m['reply'])): ?>
          <p><strong>Reply:</strong> <?php echo nl2br(htmlspecialchars($m['reply'])); ?></p>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
<?php else: ?>
  <p>No messages received yet.</p>
<?php endif; ?>

<?php include "inc/footer.php"; ?>
