<?php
session_start();
include "db.php"; // Make sure db.php is in the same folder

// ✅ Restrict to admin users only
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo "<script>alert('Access denied! Only admins can post lessons.'); window.location='login.php';</script>";
    exit;
}

$admin_id = $_SESSION['user_id'];
$msg = "";

// ✅ Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // ✅ Collect and sanitize all form inputs safely
    $title = trim($_POST["title"] ?? '');
    $youtube_link = trim($_POST["youtube_link"] ?? '');
    $description = trim($_POST["description"] ?? '');
    $assignment = trim($_POST["assignment"] ?? '');
    $course = trim($_POST["course"] ?? '');

    if (empty($title) || empty($youtube_link) || empty($description) || empty($assignment) || empty($course)) {
        $msg = "⚠️ All fields are required.";
    } else {
        $stmt = $conn->prepare("
            INSERT INTO lessons (admin_id, title, youtube_link, description, assignment, course)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmt->bind_param("isssss", $admin_id, $title, $youtube_link, $description, $assignment, $course);

        if ($stmt->execute()) {
            $msg = "✅ Lesson posted successfully!";
        } else {
            $msg = "❌ Database Error: " . htmlspecialchars($conn->error);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Post Lesson - Xploraa Academy</title>
<style>
body {font-family:"Poppins",sans-serif;background:#f4f6fb;margin:0;}
.navbar {display:flex;justify-content:space-between;align-items:center;background:#003366;color:white;padding:15px 30px;}
.navbar a {color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover {background:#ff6600;border-radius:8px;}
.container {max-width:700px;margin:40px auto;background:white;padding:30px;border-radius:12px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}
h2 {text-align:center;color:#003366;}
label {display:block;margin-top:10px;font-weight:bold;}
input, textarea, select {width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;margin-top:5px;}
button {margin-top:15px;width:100%;background:#003366;color:white;padding:12px;border:none;border-radius:8px;font-size:16px;cursor:pointer;}
button:hover {background:#ff6600;}
.message {padding:10px;border-radius:8px;margin-bottom:15px;}
.success {background:#d4edda;color:#155724;}
.error {background:#f8d7da;color:#721c24;}
</style>
</head>
<body>

<div class="navbar">
  <div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
  <div>
    <a href="dashboard.php">Dashboard</a>
    <a href="post_lesson.php">Post Lesson</a>
    <a href="view_submissions.php">View Submissions</a>
    <a href="logout.php">Logout</a>
  </div>
</div>

<div class="container">
  <h2>📘 Post New Lesson</h2>

  <?php if ($msg): ?>
      <div class="message <?php echo (str_contains($msg, '✅')) ? 'success' : 'error'; ?>">
          <?= htmlspecialchars($msg) ?>
      </div>
  <?php endif; ?>

  <form method="POST">
    <label>Lesson Title</label>
    <input type="text" name="title" placeholder="Enter lesson title" required>

    <label>YouTube Link</label>
    <input type="text" name="youtube_link" placeholder="https://youtube.com/..." required>

    <label>Course</label>
    <select name="course" required>
      <option value="">Select Course</option>
      <option>Web Design Basics (HTML & CSS)</option>
      <option>Web Development with PHP & MySQL</option>
      <option>Python Basics</option>
      <option>Android App Development</option>
    </select>

    <label>Description</label>
    <textarea name="description" rows="5" placeholder="Write lesson details..." required></textarea>

    <label>Assignment</label>
    <textarea name="assignment" rows="4" placeholder="Write assignment for this lesson..." required></textarea>

    <button type="submit">📤 Post Lesson</button>
  </form>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:15px;margin-top:30px;">
&copy; <?= date("Y") ?> Xploraa Academy — All Rights Reserved
</footer>

</body>
</html>
