<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION["user_id"])){
    header("Location: login.php"); exit;
}

$user_id = $_SESSION["user_id"];
$msg = "";

// Fetch user
$stmt = $conn->prepare("SELECT * FROM users WHERE id=?");
$stmt->bind_param("i",$user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Update profile
if($_SERVER["REQUEST_METHOD"]==="POST"){
    $fullname = trim($_POST["fullname"]);
    $phone = trim($_POST["phone"]);
    $age = intval($_POST["age"]);
    $profile_pic = $user["profile_picture"];

    if(isset($_FILES["profile_picture"]) && $_FILES["profile_picture"]["error"]===UPLOAD_ERR_OK){
        $upload_dir = __DIR__."/uploads/";
        if(!is_dir($upload_dir)) mkdir($upload_dir,0755,true);
        $ext = strtolower(pathinfo($_FILES["profile_picture"]["name"],PATHINFO_EXTENSION));
        $allowed = ["jpg","jpeg","png","gif"];
        if(in_array($ext,$allowed)){
            $new_name = uniqid("profile_",true).".".$ext;
            $profile_pic = "uploads/".$new_name;
            move_uploaded_file($_FILES["profile_picture"]["tmp_name"],$upload_dir.$new_name);
        } else { $msg="⚠️ Invalid image"; }
    }

    $stmt = $conn->prepare("UPDATE users SET fullname=?,phone=?,age=?,profile_picture=? WHERE id=?");
    $stmt->bind_param("ssisi",$fullname,$phone,$age,$profile_pic,$user_id);
    if($stmt->execute()) { $msg="✅ Profile updated"; $_SESSION["fullname"]=$fullname; $_SESSION["profile_picture"]=$profile_pic; }
    else { $msg="❌ Error: ".$conn->error; }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Profile - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:600px;margin:50px auto;padding:0 20px;}
.card{background:white;padding:20px;border-radius:12px;box-shadow:0 0 12px rgba(0,0,0,0.1);margin-bottom:20px;}
input,button{width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
.profile-img{width:100px;height:100px;border-radius:50%;object-fit:cover;}
</style>
</head>
<body>
<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="<?= $_SESSION["role"]==="admin"?"admin_dashboard.php":"dashboard.php" ?>">Dashboard</a>
<a href="profile.php">Profile</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Edit Profile</h2>
<?php if($msg): ?><div class="<?= strpos($msg,'Error')!==false?'error':'success' ?>"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<div class="card">
<img src="<?= $user["profile_picture"] ?>" class="profile-img" alt="Profile">
<form method="POST" enctype="multipart/form-data">
<label>Full Name</label><input type="text" name="fullname" value="<?= htmlspecialchars($user["fullname"]) ?>" required>
<label>Phone</label><input type="text" name="phone" value="<?= htmlspecialchars($user["phone"]) ?>" required>
<label>Age</label><input type="number" name="age" value="<?= htmlspecialchars($user["age"]) ?>" required>
<label>Profile Picture</label><input type="file" name="profile_picture" accept="image/*">
<button type="submit">Update Profile</button>
</form>
</div>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
