<?php
session_start();
if(!isset($_SESSION['user_id'])){ header("Location: login.php"); exit; }
include "config/db.php";

$stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();
$msg = "";

if($_SERVER['REQUEST_METHOD']=="POST"){
    $fullname = trim($_POST['fullname']);
    $phone = trim($_POST['phone']);
    $stmt = $pdo->prepare("UPDATE users SET fullname=?, phone=? WHERE id=?");
    if($stmt->execute([$fullname,$phone,$_SESSION['user_id']])){
        $msg="Profile updated!";
        $user['fullname']=$fullname;
        $user['phone']=$phone;
    }else{ $msg="Update failed."; }
}

include "inc/header.php";
?>
<h2 class="section-title">Edit Profile</h2>
<?php if($msg) echo "<div class='alert'>$msg</div>"; ?>
<form method="POST" class="card fade-in" style="max-width:400px;margin:auto;">
  <label>Full Name</label>
  <input type="text" name="fullname" value="<?php echo $user['fullname']; ?>" required>
  <label>Phone</label>
  <input type="text" name="phone" value="<?php echo $user['phone']; ?>" required>
  <button type="submit" class="btn">Update</button>
</form>
<?php include "inc/footer.php"; ?>
