<?php
include __DIR__ . "/db.php";
$msg = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $fullname = trim($_POST["fullname"]);
    $email = trim($_POST["email"]);
    $phone = trim($_POST["phone"]);
    $gender = trim($_POST["gender"]);
    $country = trim($_POST["country"]);
    $state = trim($_POST["state"]);
    $age = intval($_POST["age"]);
    $role = trim($_POST["role"]);
    $course = trim($_POST["course"]);
    $password = password_hash($_POST["password"], PASSWORD_DEFAULT);

    // Profile upload
    $profile_pic = "";
    if (isset($_FILES["profile_picture"]) && $_FILES["profile_picture"]["error"] === UPLOAD_ERR_OK) {
        $upload_dir = __DIR__ . "/uploads/";
        if (!is_dir($upload_dir)) { mkdir($upload_dir, 0755, true); }
        $file_tmp = $_FILES["profile_picture"]["tmp_name"];
        $file_name = basename($_FILES["profile_picture"]["name"]);
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        $allowed_ext = ["jpg","jpeg","png","gif"];
        if (in_array($file_ext, $allowed_ext) && $_FILES["profile_picture"]["size"] <= 2*1024*1024) {
            $new_name = uniqid("profile_",true).".".$file_ext;
            $profile_pic = "uploads/".$new_name;
            move_uploaded_file($file_tmp, $upload_dir.$new_name);
        } else {
            $msg = "⚠️ Invalid file or size > 2MB";
        }
    }

    if (!$msg) {
        $stmt = $conn->prepare("INSERT INTO users(fullname,email,phone,gender,country,state,age,role,course,password,profile_picture) VALUES(?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param("ssssssissss",$fullname,$email,$phone,$gender,$country,$state,$age,$role,$course,$password,$profile_pic);
        if ($stmt->execute()) {
            header("Location: registration_successful.php"); exit;
        } else {
            $msg = "❌ Error: ".$conn->error;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Register - Xploraa Academy</title>
<style>
body {font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar {display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a {color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover {background:#ff6600;border-radius:8px;}
.form-container {max-width:600px;margin:50px auto;background:white;padding:30px;border-radius:15px;box-shadow:0 0 15px rgba(0,0,0,0.1);}
input,select,button {width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
button {background:#003366;color:white;border:none;cursor:pointer;}
button:hover {background:#ff6600;}
.success {background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error {background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
</style>
</head>
<body>
<div class="navbar">
  <div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
  <div>
    <a href="index.php">Home</a>
    <a href="register.php">Register</a>
    <a href="login.php">Login</a>
    <a href="about.php">About Us</a>
    <a href="services.php">Services</a>
    <a href="contact.php">Contact</a>
  </div>
</div>

<div class="form-container">
<h2 style="color:#003366;text-align:center;">Create Account</h2>
<?php if($msg): ?><div class="error"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="POST" enctype="multipart/form-data">
<label>Full Name</label><input type="text" name="fullname" required>
<label>Email</label><input type="email" name="email" required>
<label>Phone</label><input type="text" name="phone" required>
<label>Gender</label>
<select name="gender" required><option value="">Select</option><option>Male</option><option>Female</option></select>
<label>Country</label><input type="text" name="country" required>
<label>State</label><input type="text" name="state" required>
<label>Age</label><input type="number" name="age" min="10" max="100" required>
<label>Role</label>
<select name="role" required><option value="">Select</option><option value="student">Student</option><option value="admin">Admin</option></select>
<label>Course</label>
<select name="course" required>
<option value="">Select</option>
<option>Web Design Basics (HTML & CSS)</option>
<option>Web Development with PHP & MySQL</option>
<option>Python Basics</option>
<option>Android App Development</option>
</select>
<label>Password</label><input type="password" name="password" required>
<label>Profile Picture</label><input type="file" name="profile_picture" accept="image/*" required>
<button type="submit">Register</button>
</form>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y') ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>
</body>
</html>
