<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Our Services - Xploraa Academy</title>
  <style>
    body {
      margin: 0;
      font-family: 'Poppins', sans-serif;
      background: #f5f8ff;
      color: #333;
    }

    header {
      background: #003366;
      color: #fff;
      padding: 15px 0;
      text-align: center;
      box-shadow: 0 3px 6px rgba(0,0,0,0.1);
    }

    header h1 {
      margin: 0;
      font-size: 26px;
      font-weight: 600;
    }

    nav {
      background: #002855;
      display: flex;
      justify-content: center;
      gap: 25px;
      padding: 12px;
    }

    nav a {
      color: white;
      text-decoration: none;
      font-weight: 500;
      transition: 0.3s;
    }

    nav a:hover {
      color: #ffa500;
    }

    .container {
      padding: 60px 5%;
      text-align: center;
    }

    .container h2 {
      font-size: 32px;
      color: #003366;
      margin-bottom: 40px;
    }

    .services {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 25px;
    }

    .service-card {
      background: white;
      border-radius: 16px;
      padding: 25px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      cursor: pointer;
    }

    .service-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }

    .service-icon {
      font-size: 40px;
      color: #ffa500;
      margin-bottom: 15px;
    }

    .service-card h3 {
      color: #003366;
      margin-bottom: 10px;
    }

    .service-card p {
      font-size: 15px;
      color: #555;
    }

    footer {
      background: #003366;
      color: white;
      text-align: center;
      padding: 20px 0;
      margin-top: 50px;
    }

    footer p {
      margin: 0;
      font-size: 14px;
    }

    @keyframes fadeInUp {
      0% { opacity: 0; transform: translateY(30px); }
      100% { opacity: 1; transform: translateY(0); }
    }

    .service-card {
      animation: fadeInUp 0.8s ease forwards;
    }
  </style>
</head>
<body>

<header>
  <h1>Welcome to Xploraa Academy</h1>
</header>

<nav>
  <a href="index.php">Home</a>
  <a href="about.php">About Us</a>
  <a href="services.php">Our Services</a>
  <a href="contact.php">Contact</a>
  <a href="register.php">Register</a>
  <a href="login.php">Login</a>
</nav>

<div class="container">
  <h2>Our Services</h2>

  <div class="services">
    <div class="service-card">
      <div class="service-icon">📚</div>
      <h3>Online Learning</h3>
      <p>Access high-quality lessons, resources, and materials from expert instructors anywhere, anytime.</p>
    </div>

    <div class="service-card">
      <div class="service-icon">🎥</div>
      <h3>Video Tutorials</h3>
      <p>Watch interactive and practical video tutorials to boost your understanding and improve learning retention.</p>
    </div>

    <div class="service-card">
      <div class="service-icon">🧑‍🏫</div>
      <h3>Instructor Support</h3>
      <p>Get personalized help and mentorship from qualified tutors who guide you through your academic journey.</p>
    </div>

    <div class="service-card">
      <div class="service-icon">💬</div>
      <h3>Student Discussion</h3>
      <p>Engage with classmates and teachers through the messaging and discussion platform built into the system.</p>
    </div>

    <div class="service-card">
      <div class="service-icon">📄</div>
      <h3>Assignments & Feedback</h3>
      <p>Submit assignments easily and receive direct feedback from instructors to help you improve continuously.</p>
    </div>

    <div class="service-card">
      <div class="service-icon">🌐</div>
      <h3>Skill Development</h3>
      <p>Explore skill-based learning modules and certifications designed to help you grow professionally and personally.</p>
    </div>
  </div>
</div>

<footer>
  <p>&copy; <?php echo date("Y"); ?> Xploraa Academy. All Rights Reserved.</p>
</footer>

</body>
</html>
