<?php
session_start();
include __DIR__ . "/db.php";

if(!isset($_SESSION["user_id"]) || $_SESSION["role"]!=="student"){
    header("Location: login.php"); 
    exit;
}

$msg = "";
$student_id = $_SESSION["user_id"];
$course = $_SESSION["course"];

if(!isset($_GET['lesson_id'])){
    die("❌ Invalid lesson ID.");
}

$lesson_id = intval($_GET['lesson_id']);

// Process file upload
if($_SERVER["REQUEST_METHOD"] === "POST"){
    if(isset($_FILES['assignment_file']) && $_FILES['assignment_file']['error'] === UPLOAD_ERR_OK){
        $upload_dir = __DIR__ . "/assignments/";
        if(!is_dir($upload_dir)){
            mkdir($upload_dir, 0755, true);
        }

        $file_tmp = $_FILES['assignment_file']['tmp_name'];
        $file_name = basename($_FILES['assignment_file']['name']);
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        $allowed_ext = ["pdf","doc","docx","txt"];

        if(in_array($file_ext, $allowed_ext)){
            if($_FILES['assignment_file']['size'] <= 5 * 1024 * 1024){ // 5MB max
                $new_name = uniqid("assignment_", true) . "." . $file_ext;
                $file_path = "assignments/" . $new_name;
                move_uploaded_file($file_tmp, $upload_dir . $new_name);

                // Insert into assignments table
                $stmt = $conn->prepare("INSERT INTO assignments(student_id, lesson_id, course, file_path, submitted_at) VALUES(?,?,?,?,NOW())");
                $stmt->bind_param("iiss", $student_id, $lesson_id, $course, $file_path);
                if($stmt->execute()){
                    $msg = "✅ Assignment uploaded successfully!";
                } else {
                    $msg = "❌ Database error: ".$conn->error;
                }
            } else {
                $msg = "⚠️ File too large. Max size: 5MB.";
            }
        } else {
            $msg = "⚠️ Invalid file type. Only PDF, DOC, DOCX, TXT allowed.";
        }
    } else {
        $msg = "⚠️ Please select a file to upload.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Submit Assignment - Xploraa Academy</title>
<style>
body{font-family:Poppins,sans-serif;margin:0;background:#f5f7fa;color:#222;}
.navbar{display:flex;justify-content:space-between;background:#003366;color:#fff;padding:15px 40px;}
.navbar a{color:white;text-decoration:none;padding:8px 16px;}
.navbar a:hover{background:#ff6600;border-radius:8px;}
.container{max-width:600px;margin:50px auto;padding:0 20px;}
input,button{width:100%;margin:10px 0;padding:10px;border-radius:8px;border:1px solid #ccc;}
button{background:#003366;color:white;border:none;cursor:pointer;}
button:hover{background:#ff6600;}
.success{background:#d4edda;color:#155724;padding:10px;border-radius:8px;font-weight:bold;}
.error{background:#f8d7da;color:#721c24;padding:10px;border-radius:8px;font-weight:bold;}
</style>
</head>
<body>

<div class="navbar">
<div class="logo" style="color:#ff6600;font-weight:bold;">Xploraa Academy</div>
<div>
<a href="dashboard.php">Dashboard</a>
<a href="lessons.php">Lessons</a>
<a href="profile.php">Profile</a>
<a href="student_messages.php">Messages</a>
<a href="logout.php">Logout</a>
</div>
</div>

<div class="container">
<h2>Submit Assignment</h2>
<?php if($msg): ?>
    <div class="<?= strpos($msg,'error')!==false || strpos($msg,'⚠️')!==false ? 'error' : 'success' ?>">
        <?= htmlspecialchars($msg) ?>
    </div>
<?php endif; ?>

<form method="POST" enctype="multipart/form-data">
<label>Select Assignment File (PDF, DOC, DOCX, TXT, max 5MB)</label>
<input type="file" name="assignment_file" required>
<button type="submit">Upload Assignment</button>
</form>
</div>

<footer style="background:#003366;color:white;text-align:center;padding:25px 0;margin-top:50px;">
&copy; <?= date('Y'); ?> <span style="color:#ff6600;font-weight:bold;">Xploraa Academy</span>
</footer>

</body>
</html>
