<?php
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'student'){
    header("Location: login.php"); exit;
}
include "config/db.php";

$student_id = $_SESSION['user_id'];
$lesson_id = intval($_POST['lesson_id']);

// Fetch questions
$qstmt = $pdo->prepare("SELECT * FROM questions WHERE lesson_id=?");
$qstmt->execute([$lesson_id]);
$questions = $qstmt->fetchAll();

$total_marks = 0;
foreach($questions as $q){
    $qname = 'q_'.$q['id'];
    $selected = $_POST[$qname] ?? '';
    $is_correct = ($selected == $q['correct_option']) ? 1 : 0;
    $marks_awarded = $is_correct ? $q['marks'] : 0;
    $total_marks += $marks_awarded;

    $stmt = $pdo->prepare("INSERT INTO quiz_responses (student_id,lesson_id,question_id,selected,is_correct,marks_awarded) VALUES (?,?,?,?,?,?)");
    $stmt->execute([$student_id,$lesson_id,$q['id'],$selected,$is_correct,$marks_awarded]);
}

header("Location: dashboard.php");
exit;
