<?php
session_start();
if(!isset($_SESSION['user_id']) || $_SESSION['role'] != 'student'){
    header("Location: login.php"); exit;
}
include "config/db.php";

$lesson_id = intval($_GET['lesson_id']);

// Fetch lesson
$stmt = $pdo->prepare("SELECT * FROM lessons WHERE id=?");
$stmt->execute([$lesson_id]);
$lesson = $stmt->fetch();
if(!$lesson){ die("Lesson not found."); }

// Fetch questions
$qstmt = $pdo->prepare("SELECT * FROM questions WHERE lesson_id=?");
$qstmt->execute([$lesson_id]);
$questions = $qstmt->fetchAll();

include "inc/header.php";
?>
<h2 class="section-title"><?php echo $lesson['title']; ?></h2>
<p><?php echo nl2br($lesson['content']); ?></p>

<?php if(count($questions)>0): ?>
<form method="POST" action="submit_quiz.php" class="card fade-in" style="max-width:700px;margin:auto;">
  <input type="hidden" name="lesson_id" value="<?php echo $lesson_id; ?>">
  <?php foreach($questions as $i=>$q): ?>
    <div class="card">
      <p><strong>Q<?php echo $i+1; ?>. <?php echo $q['question']; ?></strong></p>
      <label><input type="radio" name="q_<?php echo $q['id']; ?>" value="A" required> <?php echo $q['option_a']; ?></label><br>
      <label><input type="radio" name="q_<?php echo $q['id']; ?>" value="B"> <?php echo $q['option_b']; ?></label><br>
      <label><input type="radio" name="q_<?php echo $q['id']; ?>" value="C"> <?php echo $q['option_c']; ?></label><br>
      <label><input type="radio" name="q_<?php echo $q['id']; ?>" value="D"> <?php echo $q['option_d']; ?></label>
    </div>
  <?php endforeach; ?>
  <button type="submit" class="btn">Submit Quiz</button>
</form>
<?php else: ?>
<p>No questions added yet for this lesson.</p>
<?php endif; ?>

<?php include "inc/footer.php"; ?>
