<?php
// index.php — Physics Practical Lab (SS1–SS3) 🎮🧪

$experiments = [
  // SS1
  ["title" => "Hooke’s Law / Elasticity", "slug" => "hookes_law.php", "level" => "SS1", "emoji" => "🧷"],
  ["title" => "Measurement & Instruments (Vernier, Micrometer, Stopwatch)", "slug" => "#", "level" => "SS1", "emoji" => "📏"],
  ["title" => "Basic Graphs: Slope & Intercept", "slug" => "#", "level" => "SS1", "emoji" => "📈"],
  ["title" => "Thermal Expansion (Intro)", "slug" => "#", "level" => "SS1", "emoji" => "🌡️"],

  // SS2
  ["title" => "Simple Pendulum (find g)", "slug" => "simple_pendulum.php", "level" => "SS2", "emoji" => "⏱️"],
  ["title" => "Refraction & Refractive Index (Glass/Prism)", "slug" => "#", "level" => "SS2", "emoji" => "🔺"],
  ["title" => "Ohm’s Law (find R)", "slug" => "ohms_law.php", "level" => "SS2", "emoji" => "🔌"],

  // SS3
  ["title" => "Metre Bridge (Unknown Resistance)", "slug" => "#", "level" => "SS3", "emoji" => "📐"],
  ["title" => "Internal Resistance & EMF of a Cell", "slug" => "#", "level" => "SS3", "emoji" => "🔋"],
  ["title" => "Resistivity of a Wire", "slug" => "#", "level" => "SS3", "emoji" => "🧵"],
];
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Physics Lab — SS1–SS3 🎮🧪</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{ background:#f4f9ff; }
    .hero{
      background: linear-gradient(135deg,#0d6efd 0%, #6ea8fe 100%);
      color:#fff; border-radius: 1rem;
    }
    .chip{ font-size:.8rem; background:#e7f1ff; color:#084298; border-radius:999px; padding:.25rem .6rem; }
    .card:hover{ transform: translateY(-2px); transition:.2s ease; }
  </style>
</head>
<body>
  <div class="container py-4">
    <header class="hero p-4 mb-4">
      <h1 class="h3 mb-2">Physics Practical Lab — SS1 to SS3 🎮🧪</h1>
      <p class="mb-0">Practice common Nigerian secondary school physics experiments as bite-size mini-games. Start with Hooke’s Law! 🧷</p>
    </header>

    <div class="d-flex justify-content-between align-items-center mb-3">
      <h2 class="h5 mb-0">All Experiments</h2>
      <span class="chip">Mobile-friendly 🌍📱</span>
    </div>

    <div class="row g-3">
      <?php foreach($experiments as $exp): ?>
        <div class="col-12 col-md-6 col-lg-4">
          <div class="card h-100 shadow-sm">
            <div class="card-body d-flex flex-column">
              <div class="d-flex align-items-center gap-2 mb-2">
                <span style="font-size:1.3rem"><?= htmlspecialchars($exp['emoji']) ?></span>
                <h3 class="h6 mb-0"><?= htmlspecialchars($exp['title']) ?></h3>
              </div>
              <div class="mb-3">
                <span class="badge text-bg-light border"><?= htmlspecialchars($exp['level']) ?></span>
              </div>
              <div class="mt-auto">
                <?php if ($exp['slug'] === "#"): ?>
                  <a class="btn btn-outline-secondary w-100 disabled" aria-disabled="true">
                    Coming soon ⏳
                  </a>
                <?php else: ?>
                  <a class="btn btn-primary w-100" href="<?= htmlspecialchars($exp['slug']) ?>">
                    Open Experiment ▶️
                  </a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <footer class="text-center text-muted mt-4">
      <small>Built for SS1–SS3 Nigerian syllabus ✅ | Add more pages as you implement. ✨</small>
    </footer>
  </div>
</body>
</html>
